  /*
   *  Object % CRYS_C2_HASH.c    : %
   *  State           :  %state%
   *  Creation date   :  Feb. 22 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_C2_HASH.c#1:csrc:
   *  \author R.Levin (using as templet the DES files of adams)
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

/* .............. CRYS level includes ................. */

#include "DX_VOS_Mem.h"
#include "CRYS_COMMON_math.h"
#include "CRYS_C2_error.h"
#include "CRYS.h"

 
/************************ Defines ******************************/


/* canceling the PC-lint warning:
   Use of goto is deprecated */
/*lint --e{801} */

/************************ Enums *****************************************/

/************************ MACROS ****************************************/

/************************ Global Data ***********************************/


/****************************************************************************************************/
/********************************** Public Functions ************************************************/
/****************************************************************************************************/

/****************************************************************************************************/
/**
 * This function initializes the C2 HASH structures and machine registers on the CRYS level.
 *
 * This function allocates and initializes the C2 HASH Context .
 * The function receives as input a pointer to store the context handle to C2 HASH Context, 
 * it initializes the  C2 HASH Context with the cryptographic attributes that are needed for 
 * the C2 HASH block operation ( initialize H's value for the C2 HASH algorithm ).
 *
 * The function flow:
 *
 *  1) Checking the validity of the arguments - returnes an error on an illegal argument case.
 *  2) Acquiring the working context from the CCM manager.
 *  3) Initializing the context with the parameters passed by the user and with the init values
 *     of the C2 HASH.
 *  4) Loading the user tag to the context.
 *  5) Release the CCM context.
 * 
 * @param[in] ContextID_ptr - A pointer to the C2 HASH context buffer allocated by the user.
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 *      
 */
CEXPORT_C CRYSError_t CRYS_C2_HASH_Init(CRYS_C2HASHUserContext_t     *ContextID_ptr)
{
   /* FUNCTION DECLARATIONS */

   /* The return error identifier */
   CRYSError_t Error;
   
   /* FUNCTION LOGIC */
   
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;

   return Error;


}/* END OF CRYS_C2_HASH_Init */                           


/****************************************************************************************************/
/**
 * This function performs C2 HASH operations on block of data.
 *
 * The function flow:
 *
 *  1) Checking the parameters validty if there is an error the function shall exit with an error code. 
 *  2) Acquiring the working context from the CCM manager.
 *  3) If there isn't enough data in the previous update data buff in the context plus the received data,
 *     the function loads received data to the context buffer and exits.
 *  4) Filling the previous update data buffer to contain an entire block. 
 *  5) Calling the low level C2 HASH function to execute the update.
 *  6) Filling the previous update data buffer with the data not processed at the end of the received data.
 *  7) Releases the CCM context.
 * 
 * @param[in] ContextID_ptr - A pointer to the C2 HASH context buffer allocated by the user.
 *
 * @param[in] DataIn_ptr - A pointer to the buffer that stores the data to be hashed .
  * 
 * @param[in] DataInSize - The size of the data to be hashed in bytes. 
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 *
 */
CEXPORT_C CRYSError_t CRYS_C2_HASH_Update( CRYS_C2HASHUserContext_t  *ContextID_ptr,
                                           DxUint8_t                 *DataIn_ptr,
                                           DxUint32_t                 DataInSize )
{                             
   /* FUNCTION DECLARATIONS */

   /* The return error identifier */
   CRYSError_t Error;
   
   /* FUNCTION LOGIC */
  
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;
 
                                      
   return Error;
   
 
}/* END OF CRYS_C2_HASH_Update */ 


/****************************************************************************************************/
/**
 * This function finalize the hashing process of data block.
 *
 *  The function flow:
 *
 *  1) Checks the parameters validty if there is an error the function shall exit with an error code. 
 *  2) Acquiring the working context from the CCM manager.
 *  3) Setting the padding bit to last block according to CPRM requirements.
 *  4) Calling the C2 ECB Encrypt low level function to execute the last padded block.
 *  5) Output HASH result.
 *  6) Calls the CRYS_C2_HASH_Free function and exits.
 *
 *  @param[in] ContextID_ptr - A pointer to the HASH context buffer allocated by the user that
 *                             is used for the HASH machine operation.
 *
 *  @param[out] HashResultBuff - A pointer to the target buffer where the 
 *                              C2 HASH result stored in the context is loaded to.
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 */
CEXPORT_C CRYSError_t CRYS_C2_HASH_Finish( CRYS_C2HASHUserContext_t  *ContextID_ptr ,
                                           CRYS_C2HASH_Result_t       HashResultBuff )
{  
   /* FUNCTION DECLARATIONS */

   /* The return error identifier */
   CRYSError_t Error;
   
   /* FUNCTION LOGIC */
                            
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;

   return Error;   
 

}/* END OF CRYS_C2_HASH_Finish */


/****************************************************************************************************/
/**
 * @brief This function is a service function that frees the context if the operation has
 *        failed or C2 is finished. 
 *
 *        The function executes the following steps:
 *
 *        1. Checks that the context pointer is not DX_NULL (*ContextID_ptr). 
 *        2. Clearing the users context.
 *        3. Exit the handler with the OK code.
 *
 * @param[in] ContextID_ptr - a pointer to the C2 HASH context buffer allocated by the user that
 *                       was used for the C2 HASH operations. This should be the same context 
 *                       that was used on the previous call of this session.
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 */
CEXPORT_C CRYSError_t  CRYS_C2_HASH_Free(CRYS_C2HASHUserContext_t  *ContextID_ptr )
{

   /* FUNCTION DECLARATIONS */

   /* The return error identifier */
   CRYSError_t Error;

   /* FUNCTION LOGIC */
 
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;

       
   return Error;
   
 
}/* END OF CRYS_C2_HASH_Free */


/****************************************************************************************************/                     
/**
 * This function performs all C2 HASH operations on one buffer of data.
 *
 * The function simply sequentially calls the C@ HASH Init, Block and Finish functions.
 *
 *
 * @param[in] DataIn_ptr - A pointer to the buffer that stores the data to be hashed .
 * 
 * @param[in] DataInSize - The size of the data to be hashed in bytes. 
 *
 * @param[out] HashResultBuff - A pointer to the target buffer where the 
 *                              C2 HASH result stored in the context is loaded to.
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 */
CEXPORT_C CRYSError_t CRYS_C2_HASH( 
                                DxUint8_t              *DataIn_ptr,
                                DxUint32_t              DataSize,
                                CRYS_C2HASH_Result_t    HashResultBuff )
{    
   /* FUNCTION DECLARATIONS */

   /* The return error identifier */
   CRYSError_t Error;
   
   /* FUNCTION LOGIC */
   
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;

   return Error;
   
   
}/* END OF CRYS_C2_HASH */   
